clear
set more off
capture log close
version 14


global j "D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk2"


* Participation in Scanning Study
************************************
* condition on having a mobile device

* DATA SETUP
*****************


use $j/cr-7, clear

svyset i_psu, strata(i_strata)

* pick first observation per respondent
bysort pidp (starttime): keep if _n==1
count

* drop those found ineligible for the scanning study
drop if eligible==0
tab eligible

* drop IP9 non-respondents
tab ip9
tab ip9, nolab
keep if ip9==1


* mode of IP9 interview:
tab i_indmode


* drop telephone respondents
drop if i_indmode==2

* drop if CAPI resopondent and did not complete the self-completion section
drop if nosc_dv==1

* size of analysis sample
* number of participants in analysis sample
tab everapp_dv

tab smtabmiss
keep if smtabmiss==1


* RQ5: Prevalence of potential barriers? 
* Which of the potential barriers is most important in preventing partication?
***************************************************************************************
* recode variables to include respondents missing by design in one of the response categories
* include DK/REF with the missing by design - check how many DK/REF case
* reverse code items such that first category is highest disposition for all variables
* drop CATI respondents that weren't asked the self-completion, and CAPI respondents who didn't complete the self-completion section

* check % of DK/Ref/missing answers among Rs eligible for each question
* in the analysis sample (i.e. conditional on having a device)
foreach w in i_netpuse i_schomewifi i_sccontrtsp i_scfrqusesp i_scfrqusetb ///
	i_scphotosp  i_scbuysp  i_scbanksp i_scinstalsp ///
	i_scphototb  i_scbuytb  i_scbanktb i_scinstaltb ///
	i_scskillsp i_scskilltb i_scworry2 i_scworry5 ///
	i_scwrrymod1 i_scwrrymod2 i_scwrrymod3 i_scwrrymod4 i_scwrrymod5 i_scwrrymod6 ///
	i_scwill5sp i_scwill5tb i_scwill2sp i_scwill2tb ///
	i_scsmtphone i_sctablet ///
	i_fcacon1 i_indmode{
		tab `w' if `w'~=-8  
		}

tab i_schomewifi
tab i_schomewifi, nolab
recode i_schomewifi (min/-1 = 2 "no or missing") (1=1 "wifi at home"), gen(wifi)
tab i_schomewifi wifi, miss

tab i_sccontrtsp
tab i_sccontrtsp, nolab
lab list i_sccontrtsp
recode i_sccontrtsp (1=1 "fixed data plan") (2=2 "pay-as-you-go contract") (min/-1 = 3 "neither or missing"), gen(contract)
tab i_sccontrtsp contract, miss

foreach w in sp tb {
tab i_scfrquse`w'
tab i_scfrquse`w', nolab
recode i_scfrquse`w' (1=1 "every day") (2=2 "several times a week") (3=3 "several times a month") ///
     (min/-1 4=4 "once a month or missing"), gen(freq`w')
tab i_scfrquse`w' freq`w', miss
	}
	
foreach w in sp tb {
tab i_scphoto`w'
tab i_scphoto`w' , nolab
recode i_scphoto`w' (min/-1 = 2 "no or missing") (1=1 "yes"), gen(photos`w')
tab i_scphoto`w' photos`w', miss

tab i_scbuy`w'
tab i_scbuy`w' , nolab
recode i_scbuy`w' (min/-1 = 2 "no or missing") (1=1 "yes"), gen(buyonline`w')
tab i_scbuy`w' buyonline`w', miss

tab i_scbank`w'
tab i_scbank`w', nolab
recode i_scbank`w' (min/-1 = 2 "no or missing") (1=1 "yes"), gen(bankonline`w')
tab i_scbank`w' bankonline`w', miss

tab i_scinstal`w'
tab i_scinstal`w', nolab
recode i_scinstal`w' (min/-1 = 2 "no or missing") (1=1 "yes"), gen(install`w')
tab i_scinstal`w' install`w', miss
	}
	
foreach w in sp tb {
tab i_scskill`w'
tab i_scskill`w', nolab
recode i_scskill`w' (5=1 "advanced") (4=2) (3=3) (2=4) (-9 -8 1=5 "beginner or missing"), gen(skill`w')
tab i_scskill`w' skill`w', miss
	}


tab i_scworry2
tab i_scworry2, nolab
recode i_scworry2 (1=1 "not at all concerned") (2=2 "a little concerned") (3=3 "somewhat concerned") ///
	(4=4 "very concerned") (min/-1 = 5 "extremely concerned"), gen(worryapp)
tab i_scworry5
recode i_scworry5 (1=1 "not at all concerned") (2=2 "a little concerned") (3=3 "somewhat concerned") ///
	(4=4 "very concerned") (min/-1 = 5 "extremely concerned"), gen(worrycamera)
tab i_scworry2 worryapp, miss
tab i_scworry5 worrycamera, miss

forvalues n=1/6 {
tab1 i_scwrrymod`n'
recode i_scwrrymod`n' (1=1 "not at all concerned") (2=2 "a little concerned") (3=3 "somewhat concerned") ///
	(4=4 "very concerned") (min/-1 = 5 "extremely concerned"), gen(worry`n')
tab i_scwrrymod`n' worry`n', miss
	}



clonevar smtab2_dv = smtab_dv
replace smtab2_dv=0 if smtab_dv==.
tab smtab_dv smtab2_dv, miss

tab i_scwill5sp
recode i_scwill5sp (1=1 "very willing") (2=2 "somewhat willing") (3=3 "a little willing") (min/0 4=4 "not at all willing") , gen(willsp_camera)
tab i_scwill5sp willsp_camera, miss

tab i_scwill5tb
recode i_scwill5tb (1=1 "very willing") (2=2 "somewhat willing") (3=3 "a little willing") (min/0 4=4 "not at all willing"), gen(willtb_camera)
tab i_scwill5tb willtb_camera, miss

tab i_scwill2sp
recode i_scwill2sp (1=1 "very willing") (2=2 "somewhat willing") (3=3 "a little willing") (min/0 4=4 "not at all willing") , gen(willsp_app)
tab i_scwill2sp  willsp_app, miss

tab i_scwill2tb
recode i_scwill2tb (1=1 "very willing") (2=2 "somewhat willing") (3=3 "a little willing") (min/0 4=4 "not at all willing"), gen(willtb_app)
tab i_scwill2tb  willtb_app, miss

tab i_scsmtphone
recode i_scsmtphone (min/-1 = 2 "no / not asked") (1=1 "yes"), gen(smartphone)
tab i_scsmtphone smartphone, miss

tab  i_sctablet 
recode i_sctablet (min/-1 = 2 "no / not asked") (1=1 "yes"), gen(tablet)
tab i_sctablet tablet, miss

*median split for inr
sum inr, detail
gen highinr = inr > r(p50) 
lab def highinr 0 "low item non-response rates" 1 "high item non-response rate"
lab val highinr highinr
tab highinr

sum inr2, detail
gen highinr2 = inr2 > r(p50) 
lab def highinr2 0 "low item non-response rates" 1 "high item non-response rate"
lab val highinr2 highinr2
tab highinr2

// use original INR indicator
// with revised version too many people don't have any INR - median split indicator does not make sense

* mode of interview
tab i_indmode
recode i_indmode (1 =1 "capi") (3=2 "web"), gen(mode)
tab i_indmode mode, miss


* create combined / collapsed variables

recode internet (1=1 "every day") (2=2 "several times a week") (3 4=3 "less or never"), gen(internet2)
tab internet internet2, miss
lab var internet2 "freq of internet use, collapsed"

gen freq2 = freqsp if freqsp <= freqtb // 1=every day... 4=once a month or missing
replace freq2 = freqtb if freqtb < freqsp
lab val freq2 freqsp
list freqsp freqtb freq2 in 1/100
tab freq2
tab freq2 everapp_dv
recode freq2 (1=1 "every day") (2 3 4 = 2 "less often or never"), gen(freq3)
tab freq2 freq3, miss
lab var freq3 "highest freq of SP or TB use"

gen skill2 = skillsp if skillsp <= skilltb // 1=advanced...5=beginner or missing
replace skill2 = skilltb if skilltb < skillsp
lab val skill2 skillsp
list skillsp skilltb skill2 in 1/100
lab var skill2 "highest skills of SP or TB use"
recode skill2 (1 2 = 1 "advanced") (3 4 = 2 "medium") (5 = 3 "beginner"), gen(skill3)
lab var skill3 "highest skills of SP or TB use"
tab skill2 skill3, miss


foreach w in photos buyonline bankonline install {  
	gen `w' = `w'sp if `w'sp <= `w'tb        // 1=yes 2=no
	replace `w' = `w'tb if `w'tb < `w'sp
	lab val `w' `w'sp	
	list `w'* in 1/100
	assert `w'==1 if `w'sp==1
	assert `w'==1 if `w'tb==1
	lab var `w' "`w' on SP or TB"
	}

gen will_c = willsp_camera if willsp_camera <= willtb_camera  // 1=very willing...4=not at all willing
replace will_c = willtb_camera if willtb_camera < willsp_camera
list will*_c* in 1/100
assert will_c <= willsp_camera
assert will_c <= willtb_camera
recode will_c (1 2 = 1 "very or somewhat willing") (3 4 = 2 "a little or not willing"), gen(will_camera)
tab will_c will_camera, miss
lab var will_camera "highest willingness SP or TB"
drop will_c

gen will_a = willsp_app if willsp_app <= willtb_app
replace will_a = willtb_app if willtb_app < willsp_app
list will*_a* in 1/100
assert will_a <= willsp_app
assert will_a <= willtb_app
recode will_a (1 2 = 1 "very or somewhat willing") (3 4 = 2 "a little or not willing"), gen(will_app)
tab will_a will_app, miss
lab var will_app "highest willingness SP or TB"
drop will_a

foreach w in worryapp worrycamera {
	recode `w' (1=1 "not at all concerned") (2 3 = 2 "a little/somewhat concerned") ///
	(4 5 = 3 "very/extremely concerned"), gen(`w'2)
	tab `w' `w'2, miss
	lab var `w'2 "lowest concern SP or TB"
	}

	

* frequency distributions of barriers
*----------------------------------------

cd D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk

tab1 internet2 smartphone tablet wifi contract ///
	freq3 skill3  photos buyonline bankonline install /// 
	will_app  will_camera  ///
	worryapp2 worrycamera2  ///
	highinr fca  mode 


foreach w in internet2 smartphone tablet wifi contract ///
	freq3 skill3  photos buyonline bankonline install /// 
	will_app  will_camera  ///
	worryapp2 worrycamera2  ///
	highinr fca  mode {
tabout `w' using barriers.xls , append
	}

svy: tab fca everapp, row percent



* bivariate tables
*----------------------

capture program drop barroutc
program define barroutc

capture matrix drop `2'
svy: tab `1' download_dv, percent row	
matrix Rows = e(Row)
local z = colsof(Rows)

matrix Empty = J(`z',2,.)
matrix Obs = e(Obs)
matrix `2' = Rows',Empty
forvalues n = 1/`z' {
	matrix `2'[`n',2]=Obs[`n',2]/(Obs[`n',1]+Obs[`n',2])*100
	}
matrix `2'[`z',3] = e(p_Pear)
	
svy: tab `1' everapp_dv, percent row	
matrix Obs = e(Obs)
matrix `2' = `2',Empty
forvalues n = 1/`z' {
	matrix `2'[`n',4]=Obs[`n',2]/(Obs[`n',1]+Obs[`n',2])*100
	}
matrix `2'[`z',5] = e(p_Pear)

svy: tab `1' week5_dv, percent row	
matrix Obs = e(Obs)
matrix `2' = `2',Empty
forvalues n = 1/`z' {
	matrix `2'[`n',6]=Obs[`n',2]/(Obs[`n',1]+Obs[`n',2])*100
	}
matrix `2'[`z',7] = e(p_Pear)

matrix colnames `2' = junk download% downloadPr everuse% everusePr week5% week5Pr
end

	
barroutc internet2 A
barroutc smartphone B
barroutc tablet C
barroutc wifi D
barroutc contract E
barroutc freq3 F
barroutc skill3 G
barroutc photos H
barroutc buyonline I
barroutc bankonline J
barroutc install K
barroutc will_app L
barroutc will_camera M
barroutc worryapp2 N
barroutc worrycamera2  O
barroutc highinr P
barroutc fca Q
barroutc mode R

matrix X = A \ B \ C \ D \ E \ F \ G \ H \ I \ J \ K \ L \ M \ N \ O \ P \ Q \ R 
matrix list X
	


	

* Probit	
*------------


* without socio-demographics:
*--------------------------------

quietly svy: probit everapp_dv  ///
	ib3.internet2 ib2.smartphone ib2.tablet ib2.wifi ib3.contract
estat gof
margins, dydx(*)
test _b[1.internet2] = _b[2.internet2] = 0
test _b[1.contract] = _b[2.contract] = 0


quietly svy: probit everapp_dv  ///
	ib2.freq3 ib3.skill3 ib2.photos ib2.buyonline ib2.bankonline ib2.install
estat gof
margins, dydx(*)
*test _b[1.skill2] = _b[2.skill2] = _b[3.skill2] = _b[4.skill2] = 0
test _b[1.skill3] = _b[2.skill3] = 0


quietly svy: probit everapp_dv ///
	ib2.will_app  ib2.will_camera   ///
	ib3.worryapp2 ib3.worrycamera2 
estat gof
margins, dydx(*)
test _b[1.worryapp2] = _b[2.worryapp2] = 0
test _b[1.worrycamera2] = _b[2.worrycamera2] = 0

quietly svy: probit everapp_dv ///
	ib1.highinr ib2.fca ib1.mode
estat gof
margins, dydx(*)

quietly svy: probit everapp_dv ///
	ib3.internet2 ib2.smartphone ib2.tablet ib2.wifi ib3.contract ///
	ib2.freq3 ib3.skill3 ib2.photos ib2.buyonline ib2.bankonline ib2.install ///
	ib2.will_app  ib2.will_camera   ///
	ib3.worryapp2 ib3.worrycamera2  ///
	ib1.highinr ib2.fca ib1.mode
estat gof
margins, dydx(*)
test _b[1.internet2] = _b[2.internet2] = 0
test _b[1.contract] = _b[2.contract] = 0
*test _b[1.skill2] = _b[2.skill2] = _b[3.skill2] = _b[4.skill2] = 0
test (1.skill3=0) (2.skill3=0)
test _b[1.worryapp2] = _b[2.worryapp2] = 0
test _b[1.worrycamera2] = _b[2.worrycamera2] = 0


	
	
* with socio-demographics:
*--------------------------------
quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual 
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0


quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual ///
	ib3.internet2 ib2.smartphone ib2.tablet ib2.wifi ib3.contract 
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0
test _b[1.internet2] = _b[2.internet2] = 0
test _b[1.contract] = _b[2.contract] = 0
 
quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual ///
	ib2.freq3 ib3.skill3 ib2.photos ib2.buyonline ib2.bankonline ib2.install  
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0
test _b[1.skill3] = _b[2.skill3] = 0

 
quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual ///
	ib2.will_app  ib2.will_camera   ///
	ib3.worryapp2 ib3.worrycamera2  
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0
test _b[1.worryapp2] = _b[2.worryapp2] = 0
test _b[1.worrycamera2] = _b[2.worrycamera2] = 0

quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual ///
	ib1.highinr ib2.fca  ib1.mode
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0

quietly svy: probit everapp_dv i.i_sex i.age_dv i.qual ///
	ib3.internet2 ib2.smartphone ib2.tablet ib2.wifi ib3.contract ///
	ib2.freq3 ib3.skill3 ib2.photos ib2.buyonline ib2.bankonline ib2.install ///
	ib2.will_app  ib2.will_camera   ///
	ib3.worryapp2 ib3.worrycamera2  ///
	ib1.highinr ib2.fca ib1.mode	
margins, dydx(*)
test _b[2.age_dv] = _b[3.age_dv] = _b[4.age_dv] = _b[5.age_dv] = _b[6.age_dv] = 0
test _b[2.qual] = _b[3.qual] = 0
test _b[1.internet2] = _b[2.internet2] = 0
test _b[1.contract] = _b[2.contract] = 0
test _b[1.skill3] = _b[2.skill3] = 0
test _b[1.worryapp2] = _b[2.worryapp2] = 0
test _b[1.worrycamera2] = _b[2.worrycamera2] = 0



exit
